﻿//
// string resource id's
//
var IDS_DsdTraitAccess = 3000;
var IDS_DsdTraitFilename = 3001;
var IDS_DsdTraitMin = 3006;
var IDS_DsdTraitMax = 3007;
var IDS_DsdTraitFromSystem = 3008;
var IDS_DsdTraitToSystem = 3009;
var IDS_DsdTraitTexture = 3010;
var IDS_DsdTraitAxesAdjustment = 3011;
var IDS_DsdTraitSpeedX = 3012;
var IDS_DsdTraitSpeedY = 3013;
var IDS_DsdTraitDepthScale = 3014;
var IDS_DsdTraitDepthPlane = 3015;
var IDS_DsdTraitCenterX = 3016;
var IDS_DsdTraitCenterY = 3017;
var IDS_DsdTraitSpeed = 3018;
var IDS_DsdTraitLuminance = 3019;
var IDS_DsdTraitExponent = 3020;
var IDS_DsdTraitRed = 3021;
var IDS_DsdTraitGreen = 3022;
var IDS_DsdTraitBlue = 3023;
var IDS_DsdTraitAlpha = 3024;

var IDS_DsdInputRGB = 3100;
var IDS_DsdInputAlpha = 3101;
var IDS_DsdInputX = 3102;
var IDS_DsdInputY = 3103;
var IDS_DsdInputS = 3104;
var IDS_DsdInputM = 3105;
var IDS_DsdInputA = 3106;
var IDS_DsdInputB = 3107;
var IDS_DsdInputV = 3108; 
var IDS_DsdInputUV = 3109;
var IDS_DsdInputUVW = 3110;
var IDS_DsdInputTime = 3111;
var IDS_DsdInputHeight = 3112;
var IDS_DsdInputXgtY = 3113;
var IDS_DsdInputXeqY = 3114;
var IDS_DsdInputXltY = 3115;
var IDS_DsdInputSurfaceNormal = 3116;
var IDS_DsdInputValueToAppend = 3117;
var IDS_DsdInputTangentSurfaceNormal = 3118;
var IDS_DsdInputDiffuseColor = 3119;

var IDS_DsdOutputResult = 3200;
var IDS_DsdOutputConstant = 3201;
var IDS_DsdOutput2dConstant = 3202;
var IDS_DsdOutput3dConstant = 3203;
var IDS_DsdOutput4dConstant = 3204;
var IDS_DsdOutputProjectedPosition = 3205;
var IDS_DsdOutputNormalizedPosition = 3206;
var IDS_DsdOutputScreenPosition = 3207;
var IDS_DsdOutputPointDepth = 3208;
var IDS_DsdOutputNormalizedPointDepth = 3209;
var IDS_DsdOutputRGB = 3210;
var IDS_DsdOutputR = 3211;
var IDS_DsdOutputG = 3212;
var IDS_DsdOutputB = 3213;
var IDS_DsdOutputA = 3214;
var IDS_DsdOutputSurfaceNormal = 3215;
var IDS_DsdOutputWorldNormal = 3216;
var IDS_DsdOutputWorldPosition = 3217;
var IDS_DsdOutputCameraVector = 3218;
var IDS_DsdOutputTangentCameraVector = 3219;
var IDS_DsdOutputMaterialSpecPower = 3220;
var IDS_DsdOutputTime = 3221;
var IDS_DsdOutputNormalizedTime = 3222;
var IDS_DsdOutputCameraWorldPos = 3223;
var IDS_DsdOutputLightDir = 3224;
var IDS_DsdOutputTangentLightDir = 3225;
var IDS_DsdOutputAbs = 3226;
var IDS_DsdOutputAdd = 3227;
var IDS_DsdOutputCeil = 3228;
var IDS_DsdOutputClamp = 3229;
var IDS_DsdOutputCos = 3230;
var IDS_DsdOutputCross = 3231;
var IDS_DsdOutputDistance = 3232;
var IDS_DsdOutputDivide = 3233;
var IDS_DsdOutputDot = 3234;
var IDS_DsdOutputFloor = 3235;
var IDS_DsdOutputFmod = 3236;
var IDS_DsdOutputFrac = 3237;
var IDS_DsdOutputLerp = 3238;
var IDS_DsdOutputMultiply = 3239;
var IDS_DsdOutputMultiplyAdd = 3240;
var IDS_DsdOutputMax = 3241;
var IDS_DsdOutputMin = 3242;
var IDS_DsdOutputNormalize = 3243;
var IDS_DsdOutputOneMinus = 3244;
var IDS_DsdOutputPow = 3245;
var IDS_DsdOutputSaturate = 3246;
var IDS_DsdOutputSin = 3247;
var IDS_DsdOutputSqrt = 3248;
var IDS_DsdOutputSubtract = 3249;
var IDS_DsdOutputVector = 3250;
var IDS_DsdOutputNormal = 3251;
var IDS_DsdOutputUV = 3252;
var IDS_DsdOutputDesaturate = 3253;
var IDS_DsdOutputFresnel = 3254;
var IDS_DsdOutputLambert = 3255;
var IDS_DsdOutputSpecular = 3256;
var IDS_DsdOutputReflectionVector = 3257;
var IDS_DsdOutputColorConstant = 3258;

var IDS_DsdNodeFinalColor = 3400;
var IDS_DsdNodePointColor = 3401;
var IDS_DsdNodeRoot = 3402;
var IDS_DsdNodeVariable = 3403;
var IDS_DsdNodeTexture = 3404;
var IDS_DsdNodePixelShader = 3405;
var IDS_DsdNodeVertexShader = 3406;
var IDS_DsdNodeConstant = 3407;
var IDS_DsdNode2dConstant = 3408;
var IDS_DsdNode3dConstant = 3409;
var IDS_DsdNode4dConstant = 3410;
var IDS_DsdNodeProjectedPosition = 3411;
var IDS_DsdNodeNormalizedPosition = 3412;
var IDS_DsdNodeScreenPosition = 3413;
var IDS_DsdNodePointDepth = 3414;
var IDS_DsdNodeNormalizedPointDepth = 3415;
var IDS_DsdNodeSurfaceNormal = 3416;
var IDS_DsdNodeWorldNormal = 3417;
var IDS_DsdNodeWorldPosition = 3418;
var IDS_DsdNodeCameraVector = 3419;
var IDS_DsdNodeTangentCameraVector = 3420;
var IDS_DsdNodeMaterialAmbient = 3421;
var IDS_DsdNodeMaterialDiffuse = 3422;
var IDS_DsdNodeMaterialSpecular = 3423;
var IDS_DsdNodeMaterialEmissive = 3424;
var IDS_DsdNodeMaterialSpecularPower = 3425;
var IDS_DsdNodeTime = 3426;
var IDS_DsdNodeNormalizedTime = 3427;
var IDS_DsdNodeCameraWorldPosition = 3428;
var IDS_DsdNodeLightDirection = 3429;
var IDS_DsdNodeTangentLightDirection = 3430;
var IDS_DsdNodeTextureSample = 3431;
var IDS_DsdNodeNormalMapSample = 3432;
var IDS_DsdNodeCubeMapSample = 3433;
var IDS_DsdNodeTextureCoordinate = 3434;
var IDS_DsdNodePanUV = 3435;
var IDS_DsdNodeParallaxUV = 3436;
var IDS_DsdNodeRotateUV = 3437;
var IDS_DsdNodeDesaturate = 3438;
var IDS_DsdNodeFresnel = 3439;
var IDS_DsdNodeIf = 3440;
var IDS_DsdNodeLambert = 3441;
var IDS_DsdNodeSpecular = 3442;
var IDS_DsdNodeAppendOntoVector = 3443;
var IDS_DsdNodeMaskVector = 3444;
var IDS_DsdNodeReflectionVector = 3445;
var IDS_DsdNodeAbs = 3446;
var IDS_DsdNodeAdd = 3447;
var IDS_DsdNodeCeil = 3448;
var IDS_DsdNodeClamp = 3449;
var IDS_DsdNodeCos = 3450;
var IDS_DsdNodeCross = 3451;
var IDS_DsdNodeDistance = 3452;
var IDS_DsdNodeDivide = 3453;
var IDS_DsdNodeDot = 3454;
var IDS_DsdNodeFloor = 3455;
var IDS_DsdNodeFmod = 3456;
var IDS_DsdNodeFrac = 3457;
var IDS_DsdNodeLerp = 3458;
var IDS_DsdNodeMultiply = 3459;
var IDS_DsdNodeMultiplyAdd = 3460;
var IDS_DsdNodeMax = 3461;
var IDS_DsdNodeMin = 3462;
var IDS_DsdNodeNormalize = 3463;
var IDS_DsdNodeOneMinus = 3464;
var IDS_DsdNodePow = 3465;
var IDS_DsdNodeSaturate = 3466;
var IDS_DsdNodeSin = 3467;
var IDS_DsdNodeSqrt = 3468;
var IDS_DsdNodeSubtract = 3469;
var IDS_DsdNodeTransform = 3470;
var IDS_DsdNodeEdgeDetection = 3471;
var IDS_DsdNodeColorConstant = 3472;
var IDS_DsdNodeBlur = 3473;
var IDS_DsdNodeSharpen = 3474;
var IDS_DsdNodeTextureDimensions = 3475;
var IDS_DsdNodeTexelDelta = 3476;

var IDS_DsdGroupHidden = 3600;
var IDS_DsdGroupUtility = 3601;
var IDS_DsdGroupConstants = 3602;
var IDS_DsdGroupParameters = 3603;
var IDS_DsdGroupMath = 3604;
var IDS_DsdGroupTexture = 3605;
var IDS_DsdGroupFilters = 3606;

var IDS_DsdTooltipFinalColor = 3700;
var IDS_DsdTooltipPointColor = 3701;
var IDS_DsdTooltipRoot = 3702;
var IDS_DsdTooltipVariable = 3703;
var IDS_DsdTooltipTexture = 3704;
var IDS_DsdTooltipPixelShader = 3705;
var IDS_DsdTooltipVertexShader = 3706;
var IDS_DsdTooltipConstant = 3707;
var IDS_DsdTooltip2dConstant = 3708;
var IDS_DsdTooltip3dConstant = 3709;
var IDS_DsdTooltip4dConstant = 3710;
var IDS_DsdTooltipProjectedPosition = 3711;
var IDS_DsdTooltipNormalizedPosition = 3712;
var IDS_DsdTooltipScreenPosition = 3713;
var IDS_DsdTooltipPointDepth = 3714;
var IDS_DsdTooltipNormalizedPointDepth = 3715;
var IDS_DsdTooltipSurfaceNormal = 3716;
var IDS_DsdTooltipWorldNormal = 3717;
var IDS_DsdTooltipWorldPosition = 3718;
var IDS_DsdTooltipCameraVector = 3719;
var IDS_DsdTooltipTangentCameraVector = 3720;
var IDS_DsdTooltipMaterialAmbient = 3721;
var IDS_DsdTooltipMaterialDiffuse = 3722;
var IDS_DsdTooltipMaterialSpecular = 3723;
var IDS_DsdTooltipMaterialEmissive = 3724;
var IDS_DsdTooltipMaterialSpecularPower = 3725;
var IDS_DsdTooltipTime = 3726;
var IDS_DsdTooltipNormalizedTime = 3727;
var IDS_DsdTooltipCameraWorldPosition = 3728;
var IDS_DsdTooltipLightDirection = 3729;
var IDS_DsdTooltipTangentLightDirection = 3730;
var IDS_DsdTooltipTextureSample = 3731;
var IDS_DsdTooltipNormalMapSample = 3732;
var IDS_DsdTooltipCubeMapSample = 3733;
var IDS_DsdTooltipTextureCoordinate = 3734;
var IDS_DsdTooltipPanUV = 3735;
var IDS_DsdTooltipParallaxUV = 3736;
var IDS_DsdTooltipRotateUV = 3737;
var IDS_DsdTooltipDesaturate = 3738;
var IDS_DsdTooltipFresnel = 3739;
var IDS_DsdTooltipIf = 3740;
var IDS_DsdTooltipLambert = 3741;
var IDS_DsdTooltipSpecular = 3742;
var IDS_DsdTooltipAppendOntoVector = 3743;
var IDS_DsdTooltipMaskVector = 3744;
var IDS_DsdTooltipReflectionVector = 3745;
var IDS_DsdTooltipAbs = 3746;
var IDS_DsdTooltipAdd = 3747;
var IDS_DsdTooltipCeil = 3748;
var IDS_DsdTooltipClamp = 3749;
var IDS_DsdTooltipCos = 3750;
var IDS_DsdTooltipCross = 3751;
var IDS_DsdTooltipDistance = 3752;
var IDS_DsdTooltipDivide = 3753;
var IDS_DsdTooltipDot = 3754;
var IDS_DsdTooltipFloor = 3755;
var IDS_DsdTooltipFmod = 3756;
var IDS_DsdTooltipFrac = 3757;
var IDS_DsdTooltipLerp = 3758;
var IDS_DsdTooltipMultiply = 3759;
var IDS_DsdTooltipMultiplyAdd = 3760;
var IDS_DsdTooltipMax = 3761;
var IDS_DsdTooltipMin = 3762;
var IDS_DsdTooltipNormalize = 3763;
var IDS_DsdTooltipOneMinus = 3764;
var IDS_DsdTooltipPow = 3765;
var IDS_DsdTooltipSaturate = 3766;
var IDS_DsdTooltipSin = 3767;
var IDS_DsdTooltipSqrt = 3768;
var IDS_DsdTooltipSubtract = 3769;
var IDS_DsdTooltipTransform = 3770;
var IDS_DsdTooltipEdgeDetection = 3771;
var IDS_DsdTooltipColorConstant = 3772;
var IDS_DsdTooltipBlur = 3773;
var IDS_DsdTooltipSharpen = 3774;
var IDS_DsdTooltipTextureDimensions = 3775;
var IDS_DsdTooltipTexelDelta = 3776;

var IDS_DsdClampMaxDesc = 4000;
var IDS_DsdClampMinDesc = 4001;
var IDS_DsdColorConstantValueDesc = 4002;
var IDS_DsdConstantValueDesc = 4003;
var IDS_Dsd2dConstantValueDesc = 4004;
var IDS_Dsd3dConstantValueDesc = 4005;
var IDS_Dsd4dConstantValueDesc = 4006;
var IDS_DsdMaterialAmbientAccessDesc = 4007;
var IDS_DsdMaterialAmbientValueDesc = 4008;
var IDS_DsdMaterialDiffuseAccessDesc = 4009;
var IDS_DsdMaterialDiffuseValueDesc = 4010;
var IDS_DsdMaterialEmissiveAccessDesc = 4011;
var IDS_DsdMaterialEmissiveValueDesc = 4012;
var IDS_DsdMaterialSpecularAccessDesc = 4013;
var IDS_DsdMaterialSpecularValueDesc = 4014;
var IDS_DsdMaterialSpecularPowerAccessDesc = 4015;
var IDS_DsdMaterialSpecularPowerValueDesc = 4016;
var IDS_DsdCubeMapSampleTextureDesc = 4017;
var IDS_DsdNormalMapSampleAxisAdjustDesc = 4018;
var IDS_DsdNormalMapSampleTextureDesc = 4019;
var IDS_DsdPanSpeedXDesc = 4020;
var IDS_DsdPanSpeedYDesc = 4021;
var IDS_DsdParallaxDepthPlaneDesc = 4022;
var IDS_DsdParallaxDepthScaleDesc = 4023;
var IDS_DsdRotateCenterXDesc = 4024;
var IDS_DsdRotateCenterYDesc = 4025;
var IDS_DsdRotateCenterSpeedDesc = 4026;
var IDS_DsdTextureSampleTextureDesc = 4027;
var IDS_DsdTransform3dVectorFromSystemDesc = 4028;
var IDS_DsdTransform3dVectorToSystemDesc = 4029;
var IDS_DsdFresnelExponentDesc = 4030;
var IDS_DsdMaskVectorAlphaDesc = 4031;
var IDS_DsdMaskVectorBlueDesc = 4032;
var IDS_DsdMaskVectorGreenDesc = 4033;
var IDS_DsdMaskVectorRedDesc = 4034;
var IDS_DsdDesaturateLuminanceDesc = 4035;
var IDS_DsdEdgeDetectionTextureDesc = 4036;
var IDS_DsdTextureAccessDesc = 4037;
var IDS_DsdTextureFilenameDesc = 4038;
var IDS_DsdGenericVariableAccessDesc = 4039;
var IDS_DsdGenericVariableValueDesc = 4040;
var IDS_DsdBlurTextureDesc = 4041;
var IDS_DsdSharpenTextureDesc = 4042;
var IDS_DsdTextureDimensionsDesc = 4043;
var IDS_DsdTexelDeltaDesc = 4044;

//
// trait flags
//
var TraitFlagDisableDataPull = 0x0004;
var TraitFlagDefault = TraitFlagDisableDataPull;
var TraitFlagEnablePropertyWindowAccess = 0x0008 | TraitFlagDisableDataPull;
var TraitFlagInputPort = 0x0080 | TraitFlagDisableDataPull;
var TraitFlagOutputPort = 0x0100 | TraitFlagDisableDataPull;
var TraitFlagPortHidden = 0x0800;
var TraitFlagDoNotSaveAsDgsl = 0x1000;
var TraitFlagDisplayAsVector = 0x8000;

//
// parameter access
//
var DsdParameterAccessPrivate = 0;

//
// property window visualizers
//
var PropertyWindowVisualizerTextureInput = 3;
var PropertyWindowVisualizerImageFilename = 4;
var PropertyWindowVisualizerTransformSpace = 5;
var PropertyWindowVisualizerDsdParameterAccess = 6;


//
// shader templates service
//
var st = services.shaderTemplates;

//
// variable we reuse for each DSD node we add in this script
//
var node = null;


///////////////////////////////////////////////////////////////////////////////
// Basic building block nodes for the DSD
///////////////////////////////////////////////////////////////////////////////

//
// create the root type node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Root",
        IDS_DsdNodeRoot,
        "",
        IDS_DsdGroupHidden,
        "",
        IDS_DsdTooltipRoot,
        false
        );

//
// create the variable type node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Variable",
        IDS_DsdNodeVariable,
        "",
        IDS_DsdGroupHidden,
        "",
        IDS_DsdTooltipVariable,
        false
        );

if (node != null) {
    node.getOrCreateTrait("Type", "string", TraitFlagDefault).value = "";
    node.getOrCreateTrait("Semantic", "string", TraitFlagDefault).value = "";
    node.getOrCreateTrait("Editable", "bool", TraitFlagDefault).value = false;
    node.getOrCreateTrait("IsVariable", "bool", TraitFlagDefault).value = true;

    var t = node.getOrCreateTrait("Access", "int", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitAccess, IDS_DsdGenericVariableAccessDesc);
    t.value = DsdParameterAccessPrivate;
    t.propertyWindowVisualizer = PropertyWindowVisualizerDsdParameterAccess;
}

//
// create the texture type node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Texture",
        IDS_DsdNodeTexture,
        "",
        IDS_DsdGroupHidden,
        "",
        IDS_DsdTooltipTexture,
        false
        );

if (node != null) {
    node.getOrCreateTrait("Type", "string", TraitFlagDefault).value = "Texture2D";
    node.getOrCreateTrait("Semantic", "string", TraitFlagDefault).value = "";
    node.getOrCreateTrait("Editable", "bool", TraitFlagDefault).value = true;
    node.getOrCreateTrait("IsTexture", "bool", TraitFlagDefault).value = true;
    node.getOrCreateTrait("MaterialIndex", "unsigned int", TraitFlagDefault).value = 0;

    var t = node.getOrCreateTrait("Filename", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitFilename, IDS_DsdTextureFilenameDesc);
    t.value = "";
    t.propertyWindowVisualizer = PropertyWindowVisualizerImageFilename;

    t = node.getOrCreateTrait("Access", "int", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitAccess, IDS_DsdTextureAccessDesc);
    t.value = DsdParameterAccessPrivate;
    t.propertyWindowVisualizer = PropertyWindowVisualizerDsdParameterAccess;
}

//
// create the pixel shader type node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PixelShader",
        IDS_DsdNodePixelShader,
        "",
        IDS_DsdGroupHidden,
        "",
        IDS_DsdTooltipPixelShader,
        false
        );

if (node != null) {
    node.getOrCreateTrait("IsShader", "bool", TraitFlagDefault).value = true;
    node.getOrCreateTrait("ShaderKind", "string", TraitFlagDefault).value = "Pixel";
}

//
// create the vertex shader type node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.VertexShader",
        IDS_DsdNodeVertexShader,
        "",
        IDS_DsdGroupHidden,
        "",
        IDS_DsdTooltipVertexShader,
        false
        );

if (node != null) {
    node.getOrCreateTrait("IsShader", "bool", TraitFlagDefault).value = true;
    node.getOrCreateTrait("ShaderKind", "string", TraitFlagDefault).value = "Vertex";
}

//
// create the terminal node
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PixelShaderTerminal",
        IDS_DsdNodeFinalColor,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipFinalColor,
        false
        );

if (node != null) {
    node.getOrCreateTrait("RGB", "float3", TraitFlagInputPort, IDS_DsdInputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("Alpha", "float", TraitFlagInputPort, IDS_DsdInputAlpha).value = 1.0;
    node.getOrCreateTrait("Result", "float4", TraitFlagOutputPort | TraitFlagPortHidden | TraitFlagDoNotSaveAsDgsl).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("IsTerminal", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("ShowInScriptMenu", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "CombineRGBWithAlpha({RGB}, {Alpha})";
}


///////////////////////////////////////////////////////////////////////////////
// Constants
///////////////////////////////////////////////////////////////////////////////

//
// Constant
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Constant",
        IDS_DsdNodeConstant,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipConstant,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Constant", "float", TraitFlagOutputPort | TraitFlagEnablePropertyWindowAccess, IDS_DsdOutputConstant, IDS_DsdConstantValueDesc).value = 1.0;
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{Constant}";
}

//
// Constant2
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Constant2",
        IDS_DsdNode2dConstant,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltip2dConstant,
        true
        );

if (node != null) {
    node.getOrCreateTrait("2d Constant", "float2", TraitFlagOutputPort | TraitFlagEnablePropertyWindowAccess, IDS_DsdOutput2dConstant, IDS_Dsd2dConstantValueDesc).value = [1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{2d Constant}";
}

//
// Constant3
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Constant3",
        IDS_DsdNode3dConstant,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltip3dConstant,
        true
        );

if (node != null) {
    node.getOrCreateTrait("3d Constant", "float3", TraitFlagOutputPort | TraitFlagEnablePropertyWindowAccess, IDS_DsdOutput3dConstant, IDS_Dsd3dConstantValueDesc).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{3d Constant}";
}

//
// Color Constant
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.ColorConstant",
        IDS_DsdNodeColorConstant,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipColorConstant,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Color Constant", "float4", TraitFlagOutputPort | TraitFlagEnablePropertyWindowAccess | TraitFlagPortHidden, IDS_DsdOutputColorConstant, IDS_DsdColorConstantValueDesc).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{Color Constant}";
}

//
// Constant4
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Constant4",
        IDS_DsdNode4dConstant,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltip4dConstant,
        true
        );

if (node != null) {
    node.getOrCreateTrait("4d Constant", "float4", TraitFlagOutputPort | TraitFlagEnablePropertyWindowAccess | TraitFlagDisplayAsVector, IDS_DsdOutput4dConstant, IDS_Dsd4dConstantValueDesc).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{4d Constant}";
}

//
// Normalized Position
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.NormalizedPosition",
        IDS_DsdNodeNormalizedPosition,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipNormalizedPosition,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Normalized Position", "float4", TraitFlagOutputPort, IDS_DsdOutputNormalizedPosition).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "(pixel.pos / float4(ViewportWidth, ViewportHeight, 1, 1) * float4(2, 2, 1, 1) - float4(1, 1, 0, 0))";
}

//
// Screen Position
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.ScreenPosition",
        IDS_DsdNodeScreenPosition,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipScreenPosition,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Screen Position", "float4", TraitFlagOutputPort, IDS_DsdOutputScreenPosition).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.pos";
}

//
// Point Depth
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PointDepth",
        IDS_DsdNodePointDepth,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipPointDepth,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Point Depth", "float", TraitFlagOutputPort, IDS_DsdOutputPointDepth).value = 1.0;
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.pos.w";
}

//
// Point Depth Normalized
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PointDepthNormalized",
        IDS_DsdNodeNormalizedPointDepth,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipNormalizedPointDepth,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Normalized Point Depth", "float", TraitFlagOutputPort, IDS_DsdOutputNormalizedPointDepth).value = 1.0;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.pos.z";
}

//
// Point Color
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PointColor",
        IDS_DsdNodePointColor,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipPointColor,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Point Color", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.diffuse";
}

//
// Surface Normal
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.SurfaceNormal",
        IDS_DsdNodeSurfaceNormal,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipSurfaceNormal,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Surface Normal", "float3", TraitFlagOutputPort, IDS_DsdOutputSurfaceNormal).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "surfaceNormal";
}

//
// World Normal
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.WorldNormal",
        IDS_DsdNodeWorldNormal,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipWorldNormal,
        true
        );

if (node != null) {
    node.getOrCreateTrait("World Normal", "float3", TraitFlagOutputPort, IDS_DsdOutputWorldNormal).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "worldNormal";
}

//
// World Position
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.WorldPosition",
        IDS_DsdNodeWorldPosition,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipWorldPosition,
        true
        );

if (node != null) {
    node.getOrCreateTrait("World Position", "float3", TraitFlagOutputPort, IDS_DsdOutputWorldPosition).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.worldPos";
}

//
// Camera Vector
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.CameraVector",
        IDS_DsdNodeCameraVector,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipCameraVector,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Camera Vector", "float3", TraitFlagOutputPort, IDS_DsdOutputCameraVector).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "(-toEyeVector)";
}

//
// Tangent Space Camera Vector
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TangentCameraVector",
        IDS_DsdNodeTangentCameraVector,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipTangentCameraVector,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Tangent Space Camera Vector", "float3", TraitFlagOutputPort, IDS_DsdOutputTangentCameraVector).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "(-tangentToEyeVec)";
}

//
// Tangent Space Light Direction
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TangentLightDirection",
        IDS_DsdNodeTangentLightDirection,
        "",
        IDS_DsdGroupConstants,
        "assets\\images\\dsdconstant.bmp",
        IDS_DsdTooltipTangentLightDirection,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Tangent Space Light Direction", "float3", TraitFlagOutputPort, IDS_DsdOutputTangentLightDir).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "tangentLightDir";
}


///////////////////////////////////////////////////////////////////////////////
// Parameters
///////////////////////////////////////////////////////////////////////////////

//
// MaterialAmbient
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaterialAmbient",
        IDS_DsdNodeMaterialAmbient,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipMaterialAmbient,
        true
        );

if (node != null) {
    node.getOrCreateTrait("MaterialAmbient", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialVariable";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialAmbient";

    var t = node.getOrCreateTrait("MaterialVariable", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl, "MaterialVariable");
    t.value = "MaterialAmbient";
}

//
// MaterialDiffuse
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaterialDiffuse",
        IDS_DsdNodeMaterialDiffuse,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipMaterialDiffuse,
        true
        );

if (node != null) {
    node.getOrCreateTrait("MaterialDiffuse", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialVariable";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialDiffuse";

    var t = node.getOrCreateTrait("MaterialVariable", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl, "MaterialVariable");
    t.value = "MaterialDiffuse";
}

//
// MaterialSpecular
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaterialSpecular",
        IDS_DsdNodeMaterialSpecular,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipMaterialSpecular,
        true
        );

if (node != null) {
    node.getOrCreateTrait("MaterialSpecular", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialVariable";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialSpecular";

    var t = node.getOrCreateTrait("MaterialVariable", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl, "MaterialVariable");
    t.value = "MaterialSpecular";
}

//
// MaterialEmissive
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaterialEmissive",
        IDS_DsdNodeMaterialEmissive,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipMaterialEmissive,
        true
        );

if (node != null) {
    node.getOrCreateTrait("MaterialEmissive", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialVariable";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialEmissive";

    var t = node.getOrCreateTrait("MaterialVariable", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl, "MaterialVariable");
    t.value = "MaterialEmissive";
}

//
// MaterialSpecularPower
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaterialSpecularPower",
        IDS_DsdNodeMaterialSpecularPower,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipMaterialSpecularPower,
        true
        );

if (node != null) {
    node.getOrCreateTrait("MaterialSpecularPower", "float", TraitFlagOutputPort, IDS_DsdOutputMaterialSpecPower).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialVariable";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "MaterialSpecularPower";

    var t = node.getOrCreateTrait("MaterialVariable", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl, "MaterialVariable");
    t.value = "MaterialSpecularPower";
}

//
// Time
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Time",
        IDS_DsdNodeTime,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipTime,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Time", "float", TraitFlagOutputPort, IDS_DsdOutputTime).value = 1.0;
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Time";
}

//
// Normalized Time
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.NormalizedTime",
        IDS_DsdNodeNormalizedTime,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipNormalizedTime,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Normalized Time", "float", TraitFlagOutputPort, IDS_DsdOutputNormalizedTime).value = 1.0;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "frac(Time)";
}

//
// Camera World Position
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.CameraWorldPosition",
        IDS_DsdNodeCameraWorldPosition,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipCameraWorldPosition,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Camera World Position", "float3", TraitFlagOutputPort, IDS_DsdOutputCameraWorldPos).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "EyePosition";
}

//
// Light Direction
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.LightDirection",
        IDS_DsdNodeLightDirection,
        "",
        IDS_DsdGroupParameters,
        "assets\\images\\dsdparam.bmp",
        IDS_DsdTooltipLightDirection,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Light Direction", "float3", TraitFlagOutputPort, IDS_DsdOutputLightDir).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "LightDirection[0]";
}


///////////////////////////////////////////////////////////////////////////////
// Math
///////////////////////////////////////////////////////////////////////////////

//
// abs
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Abs",
        IDS_DsdNodeAbs,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipAbs,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("abs(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputAbs).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "abs({x})";
}

//
// add
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Add",
        IDS_DsdNodeAdd,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipAdd,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("x + y", "float4", TraitFlagOutputPort, IDS_DsdOutputAdd).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{x} + {y}";
}

//
// ceil
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Ceil",
        IDS_DsdNodeCeil,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipCeil,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("ceil(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputCeil).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "ceil({x})";
}

//
// clamp
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Clamp",
        IDS_DsdNodeClamp,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipClamp,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("min", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitMin, IDS_DsdClampMinDesc).value = 0.0;
    node.getOrCreateTrait("max", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitMax, IDS_DsdClampMaxDesc).value = 1.0;
    node.getOrCreateTrait("clamp(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputClamp).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "clamp({x}, {min}, {max})";
}

//
// cos
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Cos",
        IDS_DsdNodeCos,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipCos,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("cos(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputCos).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "cos({x})";
}

//
// cross product
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Cross",
        IDS_DsdNodeCross,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipCross,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float3", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float3", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("cross(x, y)", "float3", TraitFlagOutputPort, IDS_DsdOutputCross).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "cross({x}, {y})";
}

//
// distance
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Distance",
        IDS_DsdNodeDistance,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipDistance,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("distance(x, y)", "float", TraitFlagOutputPort, IDS_DsdOutputDistance).value = 1.0;
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "distance({x}, {y})";
}

//
// divide
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Divide",
        IDS_DsdNodeDivide,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipDivide,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("x / y", "float4", TraitFlagOutputPort, IDS_DsdOutputDivide).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{x} / {y}";
}

//
// dot product
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Dot",
        IDS_DsdNodeDot,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipDot,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("dot(x, y)", "float", TraitFlagOutputPort, IDS_DsdOutputDot).value = 0.0;
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "dot({x}, {y})";
}

//
// floor
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Floor",
        IDS_DsdNodeFloor,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipFloor,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("floor(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputFloor).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "floor({x})";
}

//
// fmod
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Fmod",
        IDS_DsdNodeFmod,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipFmod,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("fmod(x, y)", "float4", TraitFlagOutputPort, IDS_DsdOutputFmod).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "fmod({x}, {y})";
}

//
// frac
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Frac",
        IDS_DsdNodeFrac,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipFrac,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("frac(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputFrac).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "frac({x})";
}

//
// lerp
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Lerp",
        IDS_DsdNodeLerp,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipLerp,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("s", "float4", TraitFlagInputPort, IDS_DsdInputS).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("lerp(x, y, s)", "float4", TraitFlagOutputPort, IDS_DsdOutputLerp).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "lerp({x}, {y}, {s})";
}

//
// multiply
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Multiply",
        IDS_DsdNodeMultiply,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipMultiply,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("x * y", "float4", TraitFlagOutputPort, IDS_DsdOutputMultiply).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{x} * {y}";
}

//
// mad
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Mad",
        IDS_DsdNodeMultiplyAdd,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipMultiplyAdd,
        true
        );

if (node != null) {
    node.getOrCreateTrait("m", "float4", TraitFlagInputPort, IDS_DsdInputM).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("a", "float4", TraitFlagInputPort, IDS_DsdInputA).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("b", "float4", TraitFlagInputPort, IDS_DsdInputB).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("(m * a) + b", "float4", TraitFlagOutputPort, IDS_DsdOutputMultiplyAdd).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "mad({m}, {a}, {b})";
}

//
// max
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Max",
        IDS_DsdNodeMax,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipMax,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("max(x, y)", "float4", TraitFlagOutputPort, IDS_DsdOutputMax).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "max({x}, {y})";
}

//
// min
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Min",
        IDS_DsdNodeMin,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipMin,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("min(x, y)", "float4", TraitFlagOutputPort, IDS_DsdOutputMin).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "min({x}, {y})";
}

//
// normalize
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Normalize",
        IDS_DsdNodeNormalize,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipNormalize,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("normalize(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputNormalize).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "normalize({x})";
}

//
// one minus
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.OneMinus",
        IDS_DsdNodeOneMinus,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipOneMinus,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("1 - x", "float4", TraitFlagOutputPort, IDS_DsdOutputOneMinus).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "(1 - {x})";
}


//
// power
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Pow",
        IDS_DsdNodePow,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipPow,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("pow(x, y)", "float4", TraitFlagOutputPort, IDS_DsdOutputPow).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pow({x}, {y})";
}

//
// saturate
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Saturate",
        IDS_DsdNodeSaturate,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipSaturate,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("saturate(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputSaturate).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "saturate({x})";
}

//
// sin
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Sin",
        IDS_DsdNodeSin,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipSin,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("sin(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputSin).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "sin({x})";
}

//
// sqrt
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Sqrt",
        IDS_DsdNodeSqrt,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipSqrt,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("sqrt(x)", "float4", TraitFlagOutputPort, IDS_DsdOutputSqrt).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "sqrt({x})";
}

//
// subtract
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Subtract",
        IDS_DsdNodeSubtract,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipSubtract,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float4", TraitFlagInputPort, IDS_DsdInputX).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("y", "float4", TraitFlagInputPort, IDS_DsdInputY).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("x - y", "float4", TraitFlagOutputPort, IDS_DsdOutputSubtract).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{x} - {y}";
}

//
// transform
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TransformVector",
        IDS_DsdNodeTransform,
        "",
        IDS_DsdGroupMath,
        "assets\\images\\dsdmath.bmp",
        IDS_DsdTooltipTransform,
        true
        );

if (node != null) {
    node.getOrCreateTrait("v", "float3", TraitFlagInputPort, IDS_DsdInputV).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("v'", "float3", TraitFlagOutputPort, IDS_DsdOutputVector).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("IsBuiltIn", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;

    var t = node.getOrCreateTrait("From System", "int", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitFromSystem, IDS_DsdTransform3dVectorFromSystemDesc);
    t.value = 0;
    t.propertyWindowVisualizer = PropertyWindowVisualizerTransformSpace;

    t = node.getOrCreateTrait("To System", "int", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitToSystem, IDS_DsdTransform3dVectorToSystemDesc);
    t.value = 0;
    t.propertyWindowVisualizer = PropertyWindowVisualizerTransformSpace;
}


///////////////////////////////////////////////////////////////////////////////
// Texture
///////////////////////////////////////////////////////////////////////////////

//
// 2d texture sample
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Texture2DSample",
        IDS_DsdNodeTextureSample,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipTextureSample,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [0.0, 0.0];
    node.getOrCreateTrait("UV[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Sample", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "{Texture}.Sample(TexSampler, {UV})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdTextureSampleTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// normal map texture sample
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.NormalMapSample",
        IDS_DsdNodeNormalMapSample,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipNormalMapSample,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [0.0, 0.0];
    node.getOrCreateTrait("UV[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("normal", "float3", TraitFlagOutputPort, IDS_DsdOutputNormal).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("Axes Adjustment", "float3", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitAxesAdjustment, IDS_DsdNormalMapSampleAxisAdjustDesc).value = [1.0, -1.0, 1.0];
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "(mad(2.0f, {Texture}.Sample(TexSampler, {UV}).rgb, -1.0f) * {Axes Adjustment})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdNormalMapSampleTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// cube texture sample
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.CubeTextureSample",
        IDS_DsdNodeCubeMapSample,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipCubeMapSample,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UVW", "float3", TraitFlagInputPort, IDS_DsdInputUVW).value = [0.0, 0.0, 0.0];
    node.getOrCreateTrait("UVW[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "normalize(mul(worldToTangent, reflect(-tangentToEyeVec, float3(0,0,1))))";
    node.getOrCreateTrait("Sample", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Cube{Texture}.Sample(TexSampler, {UVW})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdCubeMapSampleTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// Texture Coordinate 
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TexCoord0",
        IDS_DsdNodeTextureCoordinate,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipTextureCoordinate,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagOutputPort, IDS_DsdOutputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("DoNotGenerateCodeStatements", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
}

//
// Texture Dimensions 
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TexDimensions",
        IDS_DsdNodeTextureDimensions,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipTextureDimensions,
        true
        );
        
if (node != null) {
    node.getOrCreateTrait("Dimensions", "float2", TraitFlagOutputPort, IDS_DsdOutputResult).value = [1.0, 1.0];
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\SM5_PixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "GetTextureDimensions({Texture})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdTextureDimensionsDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// Texel Delta 
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.TexelDelta",
        IDS_DsdNodeTexelDelta,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipTexelDelta,
        true
        );

if (node != null) {
    node.getOrCreateTrait("TexelDelta", "float2", TraitFlagOutputPort, IDS_DsdOutputResult).value = [0.0, 0.0];
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\SM5_PixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "GetTexelDelta({Texture})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdTexelDeltaDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// panning offset
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.PanningOffset",
        IDS_DsdNodePanUV,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipPanUV,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV In", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UV In[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Time", "float", TraitFlagInputPort, IDS_DsdInputTime).value = 1.0;
    node.getOrCreateTrait("Speed X", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitSpeedX, IDS_DsdPanSpeedXDesc).value = 1.0;
    node.getOrCreateTrait("Speed Y", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitSpeedY, IDS_DsdPanSpeedYDesc).value = 1.0;
    node.getOrCreateTrait("UV Out", "float2", TraitFlagOutputPort, IDS_DsdOutputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "PanningOffset({UV In}, {Time}, {Speed X}, {Speed Y})";
}

//
// parallax offset
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Parallax",
        IDS_DsdNodeParallaxUV,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipParallaxUV,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV In", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UV In[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Height", "float", TraitFlagInputPort, IDS_DsdInputHeight).value = 1.0;
    node.getOrCreateTrait("Depth Scale", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitDepthScale, IDS_DsdParallaxDepthScaleDesc).value = 0.05;
    node.getOrCreateTrait("Depth Plane", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitDepthPlane, IDS_DsdParallaxDepthPlaneDesc).value = 0.5;
    node.getOrCreateTrait("UV Out", "float2", TraitFlagOutputPort, IDS_DsdOutputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "ParallaxOffset({UV In}, {Height}, {Depth Scale}, {Depth Plane}, tangentToEyeVec)";
}

//
// rotation 
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Rotate",
        IDS_DsdNodeRotateUV,
        "",
        IDS_DsdGroupTexture,
        "assets\\images\\dsdtextures.bmp",
        IDS_DsdTooltipRotateUV,
        true
        );

if (node != null) {
    node.getOrCreateTrait("UV In", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UV In[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Time", "float", TraitFlagInputPort, IDS_DsdInputTime).value = 1.0;
    node.getOrCreateTrait("Center X", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitCenterX, IDS_DsdRotateCenterXDesc).value = 0.5;
    node.getOrCreateTrait("Center Y", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitCenterY, IDS_DsdRotateCenterYDesc).value = 0.5;
    node.getOrCreateTrait("Speed", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitSpeed, IDS_DsdRotateCenterSpeedDesc).value = 1.0;
    node.getOrCreateTrait("UV Out", "float2", TraitFlagOutputPort, IDS_DsdOutputUV).value = [1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "RotateOffset({UV In}, {Time}, {Center X}, {Center Y}, {Speed})";
}


///////////////////////////////////////////////////////////////////////////////
// Utility
///////////////////////////////////////////////////////////////////////////////

//
// fresnel
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Fresnel",
        IDS_DsdNodeFresnel,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipFresnel,
        true
        );

if (node != null) {
    node.getOrCreateTrait("SurfaceNormal", "float3", TraitFlagInputPort, IDS_DsdInputSurfaceNormal).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("Exponent", "float", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitExponent, IDS_DsdFresnelExponentDesc).value = 3.0;
    node.getOrCreateTrait("Fresnel", "float", TraitFlagOutputPort, IDS_DsdOutputFresnel).value = 1.0;
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Fresnel({SurfaceNormal}, tangentToEyeVec, {Exponent})";
}

//
// if
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.If",
        IDS_DsdNodeIf,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipIf,
        true
        );

if (node != null) {
    node.getOrCreateTrait("x", "float", TraitFlagInputPort, IDS_DsdInputX).value = 0.0;
    node.getOrCreateTrait("y", "float", TraitFlagInputPort, IDS_DsdInputY).value = 0.0;
    node.getOrCreateTrait("x > y", "float4", TraitFlagInputPort, IDS_DsdInputXgtY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("x = y", "float4", TraitFlagInputPort, IDS_DsdInputXeqY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("x < y", "float4", TraitFlagInputPort, IDS_DsdInputXltY).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("result", "float4", TraitFlagOutputPort, IDS_DsdOutputResult).value = [0.0, 0.0, 0.0, 0.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "({x} >= {y} ? ({x} > {y} ? {x > y} : {x = y}) : {x < y})"; 
}

//
// lambert lighting calculation in tangent space
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.Lambert",
        IDS_DsdNodeLambert,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipLambert,
        true
        );

if (node != null) {
    node.getOrCreateTrait("surface normal", "float3", TraitFlagInputPort, IDS_DsdInputSurfaceNormal).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("diffuse color", "float3", TraitFlagInputPort, IDS_DsdInputDiffuseColor).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("lambert", "float3", TraitFlagOutputPort, IDS_DsdOutputLambert).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "LambertLighting(tangentLightDir, {surface normal}, MaterialAmbient.rgb, AmbientLight.rgb, LightColor[0].rgb, {diffuse color})";
}

//
// specular contribution in tangent space
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.SpecularContribution",
        IDS_DsdNodeSpecular,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipSpecular,
        true
        );

if (node != null) {
    node.getOrCreateTrait("surface normal", "float3", TraitFlagInputPort, IDS_DsdInputSurfaceNormal).value = [0.0, 0.0, 1.0];
    node.getOrCreateTrait("specular", "float3", TraitFlagOutputPort, IDS_DsdOutputSpecular).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "SpecularContribution(tangentToEyeVec, tangentLightDir, {surface normal}, MaterialSpecular.rgb, MaterialSpecularPower, LightSpecularIntensity[0], LightColor[0].rgb)";
}

//
// append to vector
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.AppendToVector",
        IDS_DsdNodeAppendOntoVector,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipAppendOntoVector,
        true
        );

if (node != null) {
    node.getOrCreateTrait("v", "float4", TraitFlagInputPort, IDS_DsdInputV).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("value to append", "float", TraitFlagInputPort, IDS_DsdInputValueToAppend).value = 0.0;
    node.getOrCreateTrait("v'", "float4", TraitFlagOutputPort, IDS_DsdOutputVector).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("IsBuiltIn", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
}

//
// trim vector
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.MaskVector",
        IDS_DsdNodeMaskVector,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipMaskVector,
        true
        );

if (node != null) {
    node.getOrCreateTrait("v", "float4", TraitFlagInputPort, IDS_DsdInputV).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("Red", "bool", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitRed, IDS_DsdMaskVectorRedDesc).value = true;
    node.getOrCreateTrait("Green", "bool", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitGreen, IDS_DsdMaskVectorGreenDesc).value = true;
    node.getOrCreateTrait("Blue", "bool", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitBlue, IDS_DsdMaskVectorBlueDesc).value = true;
    node.getOrCreateTrait("Alpha", "bool", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitAlpha, IDS_DsdMaskVectorAlphaDesc).value = true;
    node.getOrCreateTrait("v'", "float4", TraitFlagOutputPort, IDS_DsdOutputVector).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("IsBuiltIn", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
}

//
// Reflection Vector
//
node = st.addTemplate(
        "Microsoft.VisualStudio.DSD.ReflectionVector",
        IDS_DsdNodeReflectionVector,
        "",
        IDS_DsdGroupUtility,
        "assets\\images\\dsdutil.bmp",
        IDS_DsdTooltipReflectionVector,
        true
        );

if (node != null) {
    node.getOrCreateTrait("Tangent Space Surface Normal", "float3", TraitFlagInputPort, IDS_DsdInputTangentSurfaceNormal).value = [0.0, 0.0, 0.0];
    node.getOrCreateTrait("Reflection Vector", "float3", TraitFlagOutputPort, IDS_DsdOutputReflectionVector).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "reflect(-tangentToEyeVec, {Tangent Space Surface Normal})";
}


///////////////////////////////////////////////////////////////////////////////
// Filters
///////////////////////////////////////////////////////////////////////////////

//
// desaturate
//
node = st.addTemplate("Microsoft.VisualStudio.DSD.Desaturate",
        IDS_DsdNodeDesaturate,
        "",
        IDS_DsdGroupFilters,
        "assets\\images\\dsdfilters.bmp",
        IDS_DsdTooltipDesaturate,
        true);

if (node != null) {
    node.getOrCreateTrait("x", "float3", TraitFlagInputPort, IDS_DsdInputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("s", "float", TraitFlagInputPort, IDS_DsdInputS).value = 1.0;
    node.getOrCreateTrait("Luminance", "float3", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitLuminance, IDS_DsdDesaturateLuminanceDesc).value = [0.3, 0.59, 0.11];
    node.getOrCreateTrait("desaturate(x, s)", "float3", TraitFlagOutputPort, IDS_DsdOutputDesaturate).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("UsePreviewMesh", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("InferTypeFromInputs", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = false;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\CommonPixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Desaturate({x}, {Luminance}, {s})";
}

//
// Edge Detection
//
node = st.addTemplate("Microsoft.VisualStudio.DSD.EdgeDetection",
        IDS_DsdNodeEdgeDetection,
        "",
        IDS_DsdGroupFilters,
        "assets\\images\\dsdfilters.bmp",
        IDS_DsdTooltipEdgeDetection,
        true);

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [0.0, 0.0];
    node.getOrCreateTrait("UV[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Sample", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\SM5_PixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "EdgeDetectionFilter({Texture}, {UV})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdEdgeDetectionTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// Blur
//
node = st.addTemplate("Microsoft.VisualStudio.DSD.Blur",
        IDS_DsdNodeBlur,
        "",
        IDS_DsdGroupFilters,
        "assets\\images\\dsdfilters.bmp",
        IDS_DsdTooltipBlur,
        true);

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [0.0, 0.0];
    node.getOrCreateTrait("UV[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Sample", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\SM5_PixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Blur({Texture}, {UV})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdBlurTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

//
// Sharpen
//
node = st.addTemplate("Microsoft.VisualStudio.DSD.Sharpen",
        IDS_DsdNodeSharpen,
        "",
        IDS_DsdGroupFilters,
        "assets\\images\\dsdfilters.bmp",
        IDS_DsdTooltipSharpen,
        true);

if (node != null) {
    node.getOrCreateTrait("UV", "float2", TraitFlagInputPort, IDS_DsdInputUV).value = [0.0, 0.0];
    node.getOrCreateTrait("UV[fx50_default_value]", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "pixel.uv";
    node.getOrCreateTrait("Sample", "float4", TraitFlagOutputPort | TraitFlagPortHidden).value = [1.0, 1.0, 1.0, 1.0];
    node.getOrCreateTrait("rgb", "float3", TraitFlagOutputPort, IDS_DsdOutputRGB).value = [1.0, 1.0, 1.0];
    node.getOrCreateTrait("r", "float", TraitFlagOutputPort, IDS_DsdOutputR).value = 1.0;
    node.getOrCreateTrait("g", "float", TraitFlagOutputPort, IDS_DsdOutputG).value = 1.0;
    node.getOrCreateTrait("b", "float", TraitFlagOutputPort, IDS_DsdOutputB).value = 1.0;
    node.getOrCreateTrait("a", "float", TraitFlagOutputPort, IDS_DsdOutputA).value = 1.0;
    node.getOrCreateTrait("ProvidePropertiesViaTrait_1", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Texture";
    node.getOrCreateTrait("IsTextureReference", "bool", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = true;
    node.getOrCreateTrait("SM5_Source", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "assets\\scripts\\hlsl\\SM5_PixelShaderHelpers.ps";
    node.getOrCreateTrait("Fx50Fragment", "string", TraitFlagDefault | TraitFlagDoNotSaveAsDgsl).value = "Sharpen({Texture}, {UV})";

    var t = node.getOrCreateTrait("Texture", "string", TraitFlagEnablePropertyWindowAccess, IDS_DsdTraitTexture, IDS_DsdSharpenTextureDesc);
    t.value = "Texture1";
    t.propertyWindowVisualizer = PropertyWindowVisualizerTextureInput;
}

// SIG // Begin signature block
// SIG // MIIkCgYJKoZIhvcNAQcCoIIj+zCCI/cCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // HscpDPBuC8rccoQQDtfV7TwW5/bcYx1fEEgV0HPgPdug
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFc8wghXLAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggb4wGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIDWR6nUkE6r0QfMLYjwlcL+M7POp/oXVgWjoVjME
// SIG // 2EkKMFIGCisGAQQBgjcCAQwxRDBCoCiAJgBSAGUAZwBp
// SIG // AHMAdABlAHIARABzAGQATgBvAGQAZQBzAC4AagBzoRaA
// SIG // FGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEB
// SIG // AQUABIIBAG6zdLcvQvQYFArsFXvUPudGkOXU/qR4z4ao
// SIG // qKw1mLr9GsULepjSSr6rmhkr63vwVxZtjMgYR+IMymWs
// SIG // YVOQ/7sNLHENBY/2G6+GDESeLN7//8zH0/xssdNo1ZQ4
// SIG // LcA6IwwRgW2nvnDugsxY5+AOMOTorXB9aSzLc3xkNIyT
// SIG // N5J5bucdRVvEuKzZTbBQp54Ymsh/4Hcje+IFFiFefFsz
// SIG // mUz8eESL+YrrJhJevriAcqyzfVa9nHbNnv8NywW18iSq
// SIG // 8yi5yhzaGcS6Qf3ICrhZeEOazPIxuCTlWzGNZkBxIxbT
// SIG // 6q6ijXLtI0eGI5AITo+gfC7F5oh4jupMMJriidzHdJ+h
// SIG // ghNJMIITRQYKKwYBBAGCNwMDATGCEzUwghMxBgkqhkiG
// SIG // 9w0BBwKgghMiMIITHgIBAzEPMA0GCWCGSAFlAwQCAQUA
// SIG // MIIBOgYLKoZIhvcNAQkQAQSgggEpBIIBJTCCASECAQEG
// SIG // CisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEFAAQgZOxA
// SIG // eq3MxOCquEuICIln8eexoZmvvBNxeZ8Rp97v3y0CBliv
// SIG // kjmbdRgTMjAxNzAzMDQyMzI0MDcuNjU0WjAEgAIB9KCB
// SIG // uaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UE
// SIG // CxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNO
// SIG // OjE0OEMtQzRCOS0yMDY2MSUwIwYDVQQDExxNaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBTZXJ2aWNloIIOzzCCBnEwggRZ
// SIG // oAMCAQICCmEJgSoAAAAAAAIwDQYJKoZIhvcNAQELBQAw
// SIG // gYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xMjAwBgNVBAMTKU1p
// SIG // Y3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0
// SIG // eSAyMDEwMB4XDTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIx
// SIG // NDY1NVowfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE
// SIG // AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAw
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCp
// SIG // HQ28dxGKOiDs/BOX9fp/aZRrdFQQ1aUKAIKF++18aEss
// SIG // X8XD5WHCdrc+Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmx
// SIG // MEQP8WCIhFRDDNdNuDgIs0Ldk6zWczBXJoKjRQ3Q6vVH
// SIG // gc2/JGAyWGBG8lhHhjKEHnRhZ5FfgVSxz5NMksHEpl3R
// SIG // YRNuKMYa+YaAu99h/EbBJx0kZxJyGiGKr0tkiVBisV39
// SIG // dx898Fd1rL2KQk1AUdEPnAY+Z3/1ZsADlkR+79BL/W7l
// SIG // msqxqPJ6Kgox8NpOBpG2iAg16HgcsOmZzTznL0S6p/Tc
// SIG // ZL2kAcEgCZN4zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHm
// SIG // MIIB4jAQBgkrBgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU
// SIG // 1WM6XIoxkPNDe3xGG8UzaFqFbVUwGQYJKwYBBAGCNxQC
// SIG // BAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1Ud
// SIG // EwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAU1fZWy4/oolxi
// SIG // aNE9lJBb186aGMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0
// SIG // cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJv
// SIG // ZHVjdHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3Js
// SIG // MFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0
// SIG // cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9N
// SIG // aWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcnQwgaAGA1Ud
// SIG // IAEB/wSBlTCBkjCBjwYJKwYBBAGCNy4DMIGBMD0GCCsG
// SIG // AQUFBwIBFjFodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
// SIG // UEtJL2RvY3MvQ1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUF
// SIG // BwICMDQeMiAdAEwAZQBnAGEAbABfAFAAbwBsAGkAYwB5
// SIG // AF8AUwB0AGEAdABlAG0AZQBuAHQALiAdMA0GCSqGSIb3
// SIG // DQEBCwUAA4ICAQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+um
// SIG // zPUxvs8F4qn++ldtGTCzwsVmyWrf9efweL3HqJ4l4/m8
// SIG // 7WtUVwgrUYJEEvu5U4zM9GASinbMQEBBm9xcF/9c+V4X
// SIG // NZgkVkt070IQyK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1
// SIG // L3mBZdmptWvkx872ynoAb0swRCQiPM/tA6WWj1kpvLb9
// SIG // BOFwnzJKJ/1Vry/+tuWOM7tiX5rbV0Dp8c6ZZpCM/2pi
// SIG // f93FSguRJuI57BlKcWOdeyFtw5yjojz6f32WapB4pm3S
// SIG // 4Zz5Hfw42JT0xqUKloakvZ4argRCg7i1gJsiOCC1JeVk
// SIG // 7Pf0v35jWSUPei45V3aicaoGig+JFrphpxHLmtgOR5qA
// SIG // xdDNp9DvfYPw4TtxCd9ddJgiCGHasFAeb73x4QDf5zEH
// SIG // pJM692VHeOj4qEir995yfmFrb3epgcunCaw5u+zGy9iC
// SIG // tHLNHfS4hQEegPsbiSpUObJb2sgNVZl6h3M7COaYLeqN
// SIG // 4DMuEin1wC9UJyH3yKxO2ii4sanblrKnQqLJzxlBTeCG
// SIG // +SqaoxFmMNO7dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHX
// SIG // odLFVeNp3lfB0d4wwP3M5k37Db9dT+mdHhk4L7zPWAUu
// SIG // 7w2gUDXa7wknHNWzfjUeCLraNtvTX4/edIhJEjCCBNow
// SIG // ggPCoAMCAQICEzMAAAC0Qzoc/ra6UokAAAAAALQwDQYJ
// SIG // KoZIhvcNAQELBQAwfDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEm
// SIG // MCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
// SIG // IDIwMTAwHhcNMTYwOTA3MTc1NjU4WhcNMTgwOTA3MTc1
// SIG // NjU4WjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UE
// SIG // CxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNO
// SIG // OjE0OEMtQzRCOS0yMDY2MSUwIwYDVQQDExxNaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4IFPu7XRMDo/gwC3
// SIG // zFaf95usurNdZBEegtZ61+4g+7PRCAFjl1enwuJMVqi1
// SIG // V9ugxt+z0RixHn6RrBkZUW1z/p4tbSRCIMTI70Zp0G8c
// SIG // TGFqlDMPlD7bom8lKr8Z0s4DOlIVgEVlG/3Ptf83smhm
// SIG // mWWt7v++gU1Dngt4CdYqjz2KtAcz2bBQJFHvf/Uk1BUM
// SIG // j3YY2Fa8tW2jKXTYdQdIQBmOZhiRAgJwG0Hb+SehGXXG
// SIG // lqj6QS+7esU0pjCgl5PHGmwAWoK2jABnksvMTdJsqePE
// SIG // XnkLAZWuqKS5Iv75RV4/fRkbYZw3dNmjUcXuSNlUMxSD
// SIG // X7LnD3uwH8mXvpmFcQIDAQABo4IBGzCCARcwHQYDVR0O
// SIG // BBYEFAyTq0XUbAt3L/MrV/PpJMSHB/RfMB8GA1UdIwQY
// SIG // MBaAFNVjOlyKMZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRP
// SIG // ME0wS6BJoEeGRWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY3JsL3Byb2R1Y3RzL01pY1RpbVN0YVBDQV8y
// SIG // MDEwLTA3LTAxLmNybDBaBggrBgEFBQcBAQROMEwwSgYI
// SIG // KwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY2VydHMvTWljVGltU3RhUENBXzIwMTAtMDct
// SIG // MDEuY3J0MAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwgwDQYJKoZIhvcNAQELBQADggEBAAK1YVug
// SIG // p9JqrCYvtsI0o3T7qHuQsYItqIkSXaT2ggtZPSfneh15
// SIG // LPjLcs9Ha+9v3uuSbe6v+16hkYR4419Re8SXMeBQje26
// SIG // mfeIKr9RauIj5DdH3WbixYUI7P51cet6bUmJJSEdnY4W
// SIG // 5Fik5qiVtZu0k6GKLLicITq8AVEfmOCf8+3qUMy7N4Qp
// SIG // avAibKVPrhMReWZkcCejDPq03ky7UH7En3/pgVEE3q4U
// SIG // X+YODBCBukasO2IS57XRCjDw0yns+tNwMW4KeiRRwiLm
// SIG // DiK3Q1GqU1Ui9SS159N1eCmhOltpCuCtfJnPn7SSKAd+
// SIG // qnDEMoZbSg7YRLb1PmcfecPyK1OhggN4MIICYAIBATCB
// SIG // 46GBuaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsG
// SIG // A1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0Ug
// SIG // RVNOOjE0OEMtQzRCOS0yMDY2MSUwIwYDVQQDExxNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloiUKAQEwCQYF
// SIG // Kw4DAhoFAAMVAAfAlZeuLk5uydN19tmJUZiLIG06oIHC
// SIG // MIG/pIG8MIG5MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYD
// SIG // VQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBF
// SIG // U046NERFOS0wQzVFLTNFMDkxKzApBgNVBAMTIk1pY3Jv
// SIG // c29mdCBUaW1lIFNvdXJjZSBNYXN0ZXIgQ2xvY2swDQYJ
// SIG // KoZIhvcNAQEFBQACBQDcZXBqMCIYDzIwMTcwMzA0MTY1
// SIG // NzE0WhgPMjAxNzAzMDUxNjU3MTRaMHYwPAYKKwYBBAGE
// SIG // WQoEATEuMCwwCgIFANxlcGoCAQAwCQIBAAIBBQIB/zAH
// SIG // AgEAAgIa0DAKAgUA3GbB6gIBADA2BgorBgEEAYRZCgQC
// SIG // MSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAIDB6EgoQow
// SIG // CAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQCUX+Gj
// SIG // rEQTYFhG09DCHc7vKfua0LwHkhEWsedurr0Ml26PPl+3
// SIG // KPf9VGa6j0NxiAItcu6ttaK9TLcWwXV0O+pSYrvLE2hw
// SIG // 9Mv6ox9dHt2XAQVIc4S3C+LV+IxHHC08fvjjUmjaF7Kk
// SIG // 2tApWAeIX3ESuGUd3YWWfU0gRKHdfq2Drr/iiVjTlPW6
// SIG // hK8jFBlmu2KrBqCue0eyDtVWI9UWhZPjpNwghd7zes2I
// SIG // ORbkHLt1MoPOcCTwUUyfAGkxEEtVSH864GUiUFcDRzZ8
// SIG // PYsBaxzaZ/zTwV8uINaCIeSl6KodD6RQhRSFDL0J0L1Y
// SIG // X6Og5Lo/EoGXklOCQLN2pTfvzZdgMYIC9TCCAvECAQEw
// SIG // gZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMA
// SIG // AAC0Qzoc/ra6UokAAAAAALQwDQYJYIZIAWUDBAIBBQCg
// SIG // ggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAv
// SIG // BgkqhkiG9w0BCQQxIgQg74QJgYxvqbihQTklwKjKaXb7
// SIG // 46jzsl8BCdTyGzGoV24wgeIGCyqGSIb3DQEJEAIMMYHS
// SIG // MIHPMIHMMIGxBBQHwJWXri5ObsnTdfbZiVGYiyBtOjCB
// SIG // mDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
// SIG // BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEw
// SIG // AhMzAAAAtEM6HP62ulKJAAAAAAC0MBYEFHQEi1ZxlzFj
// SIG // vne1iLGoiDQf7cn0MA0GCSqGSIb3DQEBCwUABIIBAMW0
// SIG // XgClqMZ/tYLaWDj0cWf8Srs4zujZQuZp0VOTOOKvnkKE
// SIG // cWbukcDxAXPFbbdJOkB7+QfKzJH5vI5FW67YqH3dvOtU
// SIG // NGvMghxOTqXLytMxI7xUC+KSwGm54fQLkUu1eZSf5jJT
// SIG // Tk3wBEs5g81aHjDMSB6RDIMYQX5nzwkGk25OSi0uTi8p
// SIG // yJ9tpOi9Udmd7aqvMlj6JYrqwsxa3qzA3y31TDnakWp6
// SIG // 1ICjCyEOUNAAQWlmkKEB0aPpSzzvim7mD+LtDo0ykFNB
// SIG // YgLDDvYawubXxIEODXM1qM60YV2EPCM6rPpaVd+QLJBK
// SIG // qAtu+eQULkr5Ms8ZKbskeBpYcbjCmTY=
// SIG // End signature block
